<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : forms_validation
#  Version : R2.0.8.UK1                                        
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xpath-default-namespace="http://enotice.service.gov.uk/resource/schema/UK/R2.0.8/reception">
	<xsl:output method="xml" omit-xml-declaration="no" standalone="yes" indent="yes" />
	<!--XML file name-->
	<xsl:param name="file">filename</xsl:param>
	<!--choice of message weight: PROD_WEGHT or QUAL_WEIGHT-->
	<xsl:param name="weight">PROD_WEIGHT</xsl:param>
	<xsl:include href="./build_message.xsl" />
	<xsl:strip-space elements="*" />
	<xsl:template match="/">
		<VALIDATION_REPORT>
			<xsl:choose>
				<xsl:when test="not(TED_ESENDERS[.//@VERSION='R2.0.8.UK1'])">
					<MESSAGE>Unknown file</MESSAGE>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates />
				</xsl:otherwise>
			</xsl:choose>
		</VALIDATION_REPORT>
	</xsl:template>
	<xsl:template match="TED_ESENDERS/SENDER">
		<IDENTIFICATION>
			<xsl:apply-templates />
			<xsl:element name="FILE">
				<xsl:value-of select="$file" />
			</xsl:element>
		</IDENTIFICATION>
	</xsl:template>
	<xsl:template match="ESENDER_LOGIN|CUSTOMER_LOGIN|NO_DOC_EXT">
		<xsl:choose>
			<xsl:when test="not(ancestor::SENDER)" />
			<xsl:otherwise>
				<xsl:element name="{local-name()}">
					<xsl:value-of select="current()" />
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--to control only the first form in the case of bilinguale-->
	<xsl:template match="*[@CATEGORY='ORIGINAL'][position()=1]">
		<LOGS>
			<!--<xsl:apply-templates select="." mode="R100"/>-->
			<!--<xsl:apply-templates select="." mode="R101"/>-->
			<!--<xsl:apply-templates select="//USER" mode="R102"/>-->
			<xsl:apply-templates select="//USER" mode="R103" />
			<xsl:apply-templates select="." mode="R103" />
			<xsl:apply-templates select="//USER" mode="R105" />
			<xsl:apply-templates select="." mode="R105" />
			<xsl:apply-templates select="." mode="R107" />
			<xsl:apply-templates select="/" mode="R108" />
			<xsl:apply-templates select="." mode="R109" />
			<xsl:apply-templates select="." mode="R110" />
			<xsl:apply-templates select="/" mode="R111" />
			<xsl:apply-templates select="/" mode="R112" />
			<!--<xsl:apply-templates select="." mode="R114"/>-->
			<!--<xsl:apply-templates select="." mode="R115"/>-->
			<!--<xsl:apply-templates select="." mode="R116"/>-->
			<xsl:apply-templates select="." mode="R158" />
			<xsl:apply-templates select="." mode="R251" />
			<!--section I-->
			<xsl:apply-templates select="." mode="R121" />
			<xsl:apply-templates select="." mode="R122" />
			<xsl:apply-templates select="." mode="R123" />
			<!--section II-->
			<xsl:apply-templates select="." mode="R134" />
			<xsl:apply-templates select="." mode="R135" />
			<xsl:apply-templates select="." mode="R137" />
			<xsl:apply-templates select="." mode="R139" />
			<xsl:apply-templates select="." mode="R390" />
			<!--section IV-->
			<xsl:apply-templates select="." mode="R178" />
			<xsl:apply-templates select="." mode="R197" />
			<xsl:apply-templates select="." mode="R209" />
			<xsl:apply-templates select="." mode="R557" />
			<!--section V-->
			<xsl:apply-templates select="." mode="R215" />
			<xsl:apply-templates select="." mode="R219" />
			<xsl:apply-templates select="." mode="R220" />
			<xsl:apply-templates select="." mode="R250" />
			<xsl:apply-templates select="." mode="R619" />
			<!--section VI-->
			<!--<xsl:apply-templates select="." mode="R231"/>-->
			<!--<xsl:apply-templates select="." mode="R232R233"/>-->
			<xsl:apply-templates select="." mode="R709" />
		</LOGS>
	</xsl:template>
	<xsl:template match="text()" priority="-1" />
	<xsl:template match="@*|node()" priority="-2">
		<xsl:apply-templates select="@*|*" />
	</xsl:template>
	<xsl:include href="./section0.xsl" />
	<xsl:include href="./section1.xsl" />
	<xsl:include href="./section2.xsl" />
	<xsl:include href="./section4.xsl" />
	<xsl:include href="./section5.xsl" />
	<xsl:include href="./section6.xsl" />
</xsl:stylesheet>
